<?php

/*

  type: layout

  name: Radioactive

  description: Radioactive template for Contact form
  



*/

?>


<div class="contact-form-container contact-form-template-active">
    <div class="contact-form">
        <div class="edit" data-field="contact_form_title" rel="newsletter_module" data-id="<?php print $params['id'] ?>">
            <h3 class="element contact-form-title"><?php _e("Leave a Message"); ?></h3>
        </div>
        <form class="mw_form" data-form-id="<?php print $form_id ?>" name="<?php print $form_id ?>" method="post">


            <module type="custom_fields" data-id="<?php print $params['id'] ?>" data-for="module" default-fields="name,email,message"/>

            <script>

                $(document).ready(function () {
                    var fields = $(".contact-form-template-active .module-custom-fields .control-group");
                    if (fields.length > 0) {
                        var last = fields[fields.length - 1];
                        fields.each(function (i) {
                            var index = i + 1;
                            if (index === fields.length && index % 2 !== 0) {
                                $(this).addClass('full-width');
                            }
                            else {
                                $(this).addClass((index % 2 !== 0 ? 'odd' : 'even'));
                            }
                        });
                    }

                })

            </script>
            <?php if (get_option('disable_captcha', $params['id']) != 'y'): ?>
                <module type="captcha" class="pull-left"/>
                <button type="submit" class="mw-template-btn mw-template-btn-invert pull-right"><?php _e("Send"); ?></button>
            <?php else: ?>
                <button type="submit" class="mw-template-btn mw-template-btn-invert"><?php _e("Send"); ?></button>
            <?php endif; ?>
        </form>
    </div>
    <div class="message-sent" id="msg<?php print $form_id ?>">
        <span class="message-sent-icon"></span>
        <p><?php _e("Your Email was sent successfully"); ?></p>
    </div>
</div>
