<!DOCTYPE HTML>
<html prefix="og: http://ogp.me/ns#">
<head>
    <title>{content_meta_title}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta property="og:title" content="{content_meta_title}"/>
    <meta name="keywords" content="{content_meta_keywords}"/>
    <meta name="description" content="{content_meta_description}"/>
    <meta property="og:type" content="{og_type}"/>
    <meta property="og:url" content="{content_url}"/>
    <meta property="og:image" content="{content_image}"/>
    <meta property="og:description" content="{og_description}"/>
    <meta property="og:site_name" content="{og_site_name}"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <link rel="alternate" type="application/rss+xml" title="{og_site_name}" href="<?php print site_url('rss') ?>"/>
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i&amp;subset=latin-ext" rel="stylesheet">
    <link rel="stylesheet" href="<?php print template_url(); ?>css/layouts.css" type="text/css"/>
    <?php

    $color_scheme = get_option('color-scheme', 'mw-template-active');
    if ($color_scheme == '') {
        $color_scheme = 'default';
    }


    ?>
    <script>
        mw.lib.require('jqueryui');
        mw.lib.require('bootstrap3ns');
    </script>

    <link rel="stylesheet" href="<?php print template_url(); ?>css/scheme/<?php print $color_scheme; ?>.css" id="colorscss" type="text/css"/>
    <link rel="stylesheet" href="<?php print template_url(); ?>css/css.css" type="text/css"/>
    <script src="<?php print template_url(); ?>js/functions.js"></script>

    <script>
        AddToCartModalContent = window.AddToCartModalContent || function (title) {
                var html = ''

                    + '<section class="text-center">'

                    + '<span class="sm-icon-bag2"></span>'

                    + '<h5>' + title + '</h5>'

                    + '<p class="m-t-10"><?php _e("has been added to your cart"); ?></p>'

                    + '<a href="javascript:;" onclick="mw.tools.modal.remove(\'#AddToCartModal\')" class="mw-ui-btn m-10"><?php _e("Continue shopping"); ?></a>'

                    + '<a href="<?php print checkout_url(); ?>" class="mw-ui-btn mw-ui-btn-invert m-10"><?php _e("Checkout"); ?></a></section>';

                return html;
            }
    </script>
</head>
<body>
<div id="container">
    <module
            type="layouts"
            template="header"
            menu-template="active"
            logo="<?php print template_url(); ?>img/logo.png"
            logo-template="2rows"
            height="110"
            fixed="true"/>