<?php


/*



type: layout



name: Dropdown cart



description: Dropdown cart template



*/


?>


<div class="mw-cart mw-dopdown-cart-content mw-cart-<?php print $params['id'] ?> <?php print $template_css_prefix ?>">
    <?php if (is_array($data)) : ?>

        <div class="item-box">

            <div class="mw-dopdown-cart-container">


                <table class="mw-ui-table mw-ui-table-basic">


                    <tbody>

                    <?php foreach ($data as $item) : ?>


                        <tr class="border-bottom">
                            <td style="padding: 0;">
                                <div class="mw-cart-table-product-image" style="min-width:70px;">

                                    <?php $pic = get_picture($item['rel_id']); ?>

                                    <img src="<?php print thumbnail($pic, 100, 100); ?>" alt=""/>

                                </div>
                            </td>
                            <td>
                                <table>
                                    <tbody>
                                    <tr class="mw-cart-item mw-cart-item-<?php print $item['id'] ?> title-row">
                                        <td colspan="3" class="mw-cart-table-product">
                                            <?php $substrTitle = character_limiter($item['title'], 20, '...'); ?>
                                            <?php print $substrTitle; ?>

                                            <?php if (isset($item['custom_fields'])): ?>

                                                <?php print $item['custom_fields'] ?>

                                            <?php endif ?>
                                        </td>
                                    </tr>
                                    <tr class="mw-cart-item mw-cart-item-<?php print $item['id'] ?> content-row">
                                        <td>Qty:<?php print $item['qty'] ?></td>

                                        <td class="mw-cart-table-price"><?php print currency_format($item['price'] * $item['qty']); ?></td>

                                        <td><a data-tip="<?php _e("Remove"); ?>" class="mw-icon-close  tip" href="javascript:mw.cart.remove('<?php print $item['id'] ?>');"></a></td>

                                    </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>


                    <?php endforeach; ?>

                    </tbody>

                </table>


                <?php

                if (!isset($params['checkout-link-enabled'])) {

                    $checkout_link_enanbled = get_option('data-checkout-link-enabled', $params['id']);

                } else {

                    $checkout_link_enanbled = $params['checkout-link-enabled'];

                }

                ?>

                <?php if ($checkout_link_enanbled != 'n') : ?>

                    <?php $checkout_page = get_option('data-checkout-page', $params['id']); ?>

                    <?php


                    if ($checkout_page != false and strtolower($checkout_page) != 'default' and intval($checkout_page) > 0) {

                        $checkout_page_link = content_link($checkout_page) . '/view:checkout';

                    } else {

                        $checkout_page_link = site_url('checkout');

                    }


                    ?>


                <?php endif; ?>


            </div>


            <div class="checkout-wrapper">
                <a class="btn btn-default btn-block" href="<?php print $checkout_page_link; ?>"><span class="sm-icon-bag2"></span><span><?php _e("Go to checkout"); ?></span></a>
            </div>

        </div>


    <?php else : ?>

        <div class="item-box">

            <div class="mw-dopdown-cart-container">

                <table class="mw-ui-table mw-ui-table-basic">

                    <tr>

                        <td style="white-space: nowrap">

                            <h3 style="font-size: 18px;">Your cart is empty</h3>

                        </td>

                    </tr>

                </table>


            </div>

        </div>

    <?php endif; ?>

</div>

