<?php

/*

  type: layout
  content_type: dynamic
  name: Search
  position: 5
  description: Search layout

*/

?>

<?php include TEMPLATE_DIR . "header.php"; ?>

<section id="content">
    <div class="mw-layout-wrapper text-layout-section">
        <?php
        $keywords = '';
        if (isset($_GET['keywords'])) {
            $keywords = htmlspecialchars($_GET['keywords']);
        }
        ?>
        <h2 class="page-title">Search</h2>

        <div class="clearfix bootstrap3ns">
            <div style="max-width: 250px; margin: 0 auto 40px auto;">
                <form action="<?php print site_url(); ?>search.php" method="get" class="form">
                    <?php if (isset($_GET['type'])): ?>
                        <?php if ($_GET['type'] == 'shop'): ?>
                            <input type="hidden" name="type" value="shop"/>
                        <?php elseif ($_GET['type'] == 'blog'): ?>
                            <input type="hidden" name="type" value="blog" />
                        <?php endif; ?>
                    <?php endif; ?>
                    <div class="form-group">
                        <div class="input-group">
                            <input class="form-control" type="search" placeholder="Search" id="keywords" name="keywords" value="<?php print $keywords; ?>"/>
                            <span class="input-group-btn">
                                    <button class="btn btn-default" type="submit"><i class="fa fa-search"></i></button>
                                </span>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <?php if (isset($_GET['keywords'])): ?>
            <?php if (isset($_GET['type'])): ?>
                <?php if ($_GET['type'] == 'shop'): ?>
                    <h2 class="text-center"><?php _e('Results for'); ?> <?php print $keywords; ?> in Shop</h2>
                    <module type="shop/products" template="active" limit="18" keyword="<?php print $keywords; ?>" description-length="70"/>
                <?php elseif ($_GET['type'] == 'blog'): ?>
                    <h2 class="text-center"><?php _e('Results for'); ?> <?php print $keywords; ?> in Blog</h2>
                    <module type="posts" limit="18" template="active" keyword="<?php print $keywords; ?>" description-length="70"/>
                <?php endif; ?>
            <?php else: ?>
                <h2 class="text-center"><?php _e('Results for'); ?> <?php print $keywords; ?> in Shop</h2>
                <module type="shop/products" template="active" limit="18" keyword="<?php print $keywords; ?>" description-length="70"/>
                <br/><br/>
                <br/><br/>

                <h2 class="text-center"><?php _e('Results for'); ?> <?php print $keywords; ?> in Blog</h2>
                <module type="posts" limit="18" template="active" keyword="<?php print $keywords; ?>" description-length="70"/>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</section>

<?php include TEMPLATE_DIR . "footer.php"; ?>
